/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.IHttpRequestResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;

public class CustomHttpRequestResponse
implements IHttpRequestResponse {
    private URL _url;
    private byte[] _request = null;
    private byte[] _response = null;
    private short _status = (short)200;
    private String _host = null;
    private String _path = null;
    private int _port = -1;
    private String _protocol = null;
    private String _comment = null;
    private String _cookie = null;
    private String _post_data = null;
    private String _method = "GET";
    private String _srequest = null;

    public CustomHttpRequestResponse(String url) throws MalformedURLException, IOException {
        this._splitURL(url);
        this._connect();
    }

    public CustomHttpRequestResponse(String url, String cookie, String postData, String Method2) throws MalformedURLException, IOException {
        this._cookie = cookie;
        this._post_data = postData;
        this._method = Method2 == null || Method2.isEmpty() ? "GET" : Method2;
        this._splitURL(url);
        this._connect();
    }

    private void _splitURL(String url) throws MalformedURLException {
        this._url = new URL(url);
        this._protocol = this._url.getProtocol().isEmpty() ? "http" : this._url.getProtocol();
        this._path = this._url.getPath().isEmpty() ? "/" : this._url.getPath();
        this._host = this._url.getHost();
        this._port = this._url.getPort() == -1 ? 80 : this._url.getPort();
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public byte[] getRequest() throws Exception {
        return this._request;
    }

    @Override
    public URL getUrl() throws Exception {
        return this._url;
    }

    @Override
    public byte[] getResponse() throws Exception {
        return this._response;
    }

    @Override
    public short getStatusCode() throws Exception {
        return this._status;
    }

    @Override
    public String getComment() throws Exception {
        return this._comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _connect() throws IOException {
        Socket socket = null;
        PrintWriter writer = null;
        BufferedReader reader = null;
        this._makeRequest();
        try {
            String line;
            socket = new Socket(this._host, this._port);
            writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            writer.write(this._srequest);
            writer.flush();
            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            StringBuilder m_sresponse = new StringBuilder(4000);
            while ((line = reader.readLine()) != null && !line.isEmpty()) {
                m_sresponse.append(line);
            }
            this._response = m_sresponse.toString().getBytes();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException logOrIgnore) {}
            }
            if (writer != null) {
                writer.close();
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException logOrIgnore) {}
            }
        }
    }

    private void _makeRequest() throws MalformedURLException, IOException {
        StringBuilder m_request = new StringBuilder(600);
        m_request.append(this._method);
        m_request.append(" ");
        m_request.append(this._path);
        m_request.append(" ");
        m_request.append("HTTP/1.1");
        m_request.append("\r\n");
        m_request.append("Host: ");
        m_request.append(this._host);
        m_request.append(":");
        m_request.append(this._port);
        m_request.append("\r\n");
        if (this._cookie != null && !this._cookie.isEmpty()) {
            m_request.append("Cookie: ");
            m_request.append(this._cookie);
            m_request.append("\r\n");
        }
        if (this._post_data != null && !this._cookie.isEmpty()) {
            int m_length = this._post_data.length();
            m_request.append("Content-Length: ");
            m_request.append(m_length);
            m_request.append("\r\n");
            m_request.append("\r\n\r\n");
            m_request.append(this._post_data);
        }
        m_request.append("\r\n\r\n");
        this._srequest = m_request.toString();
        this._request = m_request.toString().getBytes();
    }

    @Override
    public void setComment(String comment) throws Exception {
    }

    @Override
    public void setRequest(byte[] message) throws Exception {
    }

    @Override
    public void setHost(String host) throws Exception {
    }

    @Override
    public void setPort(int port) throws Exception {
    }

    @Override
    public void setProtocol(String protocol) throws Exception {
    }

    @Override
    public void setResponse(byte[] message) throws Exception {
    }
}

