/*
 * Decompiled with CFR 0.152.
 */
package CustomPlugin.sqlmap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

class ForkWorker
extends SwingWorker<String, String>
implements Runnable {
    private boolean _debug;
    private JTextArea output;
    private ProcessBuilder builder;
    private OutputStream input;

    public ForkWorker(JTextArea output, ProcessBuilder builder, boolean debug) {
        this._debug = debug;
        this.output = output;
        this.builder = builder;
    }

    @Override
    protected void process(List<String> chunks) {
        Iterator<String> it = chunks.iterator();
        while (it.hasNext()) {
            this.output.append(it.next());
        }
    }

    public void Update(char text_) {
        if (this.input != null) {
            try {
                this.input.write(text_);
                this.input.flush();
            }
            catch (IOException ex) {
                Logger.getLogger(ForkWorker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public String doInBackground() {
        Process process = null;
        try {
            int len;
            process = this.builder.start();
            InputStream res = process.getInputStream();
            this.input = process.getOutputStream();
            byte[] buffer = new byte[100];
            while ((len = res.read(buffer, 0, buffer.length)) != -1) {
                this.publish(new String(buffer, 0, len, "ISO-8859-1"));
                if (!this.isCancelled()) continue;
                process.destroy();
                return "";
            }
            this.input.close();
            this.input = null;
        }
        catch (Exception e) {
            block6: {
                if (this._debug) {
                    System.out.println("[Debug] Exception while executing sqlmap:" + e.toString());
                }
                process.destroy();
                try {
                    this.input.close();
                }
                catch (IOException ex) {
                    if (!this._debug) break block6;
                    System.out.println("[Debug] Exception while executing sqlmap:" + ex.toString());
                }
            }
            this.input = null;
        }
        return "";
    }

    @Override
    protected void done() {
        this.output.append("\n--- EXECUTION IS COMPLETE ---");
    }
}

